package shooting;

import thinkbot.*;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.LinkedList;

public class Predictor {
    LinkedList<Triple> positions = new LinkedList();
    
    public void addPosition(Triple t) {
        positions.add(t);
        if (positions.size() > 3) {
            positions.pollFirst();
        }
    }
    
    public Triple getLastPosition() {
        if (positions.isEmpty()) {
            return null;
        } else {
            return positions.getLast();
        }
    }
    
    public void reset() {
        positions.clear();
    }
    
    public Triple getFuturePosition(Triple myPosition, ItemType weaponType, boolean alternative) {
        WeaponStats ws = WeaponStats.getWeaponStats(weaponType);
        if (positions.size() == 0) {
            return null;
        } else {
            double weaponSpeed = 0;
            if (alternative) {
                weaponSpeed = ws.getSecondSpeed();
            } else {
                weaponSpeed = ws.getFirstSpeed();
            }
            if (weaponSpeed >= 5000) {
                return positions.getLast();
            }
            if (positions.size() < 2) {
                return null;
            } else {
                Triple enemySpeedVector = Triple.subtract(positions.getLast(),
                        positions.get(positions.size() - 2));
                Triple relativePos = Triple.subtract(positions.getLast(), myPosition);
                double a =  enemySpeedVector.x*enemySpeedVector.x +
                            enemySpeedVector.y*enemySpeedVector.y +
                            enemySpeedVector.x*enemySpeedVector.x -
                            weaponSpeed*weaponSpeed;
                double b = (enemySpeedVector.x + enemySpeedVector.y + enemySpeedVector.z)/2;
                double c =  relativePos.x*relativePos.x +
                            relativePos.y*relativePos.y +
                            relativePos.z*relativePos.z;
                double t =  (-b - Math.sqrt(b*b - 4*a*c))/(2*a);
                return new Triple(enemySpeedVector.x*t + positions.getLast().x,
                                  enemySpeedVector.y*t + positions.getLast().y,
                                  enemySpeedVector.z*t + positions.getLast().z);
            }
        }
    }
}